<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ResolvedForm extends Model 
{

    protected $table = 'resolved_forms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function form()
    {
        return $this->belongsTo('App\Models\Form');
    }

}